# -*- coding: utf-8 -*-

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup


import os.path

readme = ''
here = os.path.abspath(os.path.dirname(__file__))
readme_path = os.path.join(here, 'README.rst')
if os.path.exists(readme_path):
    with open(readme_path, 'rb') as stream:
        readme = stream.read().decode('utf8')


setup(
    long_description=readme,
    name='iredis',
    version='1.9.1',
    description='Terminal client for Redis with auto-completion and syntax highlighting.',
    python_requires='==3.*,>=3.6.0',
    project_urls={"homepage": "https://github.com/laixintao/iredis", "repository": "https://github.com/laixintao/iredis"},
    author='laixintao',
    author_email='laixintao1995@163.com',
    license='BSD-3-Clause',
    keywords='Redis key-value store Commandline tools Redis Client',
    classifiers=['Development Status :: 4 - Beta', 'Environment :: Console', 'Environment :: Console :: Curses', 'Environment :: MacOS X', 'Operating System :: OS Independent', 'Programming Language :: Python :: 3.6', 'Programming Language :: Python :: 3.7', 'Programming Language :: Python :: 3.8', 'Topic :: Database', 'License :: OSI Approved :: MIT License', 'Intended Audience :: Developers'],
    entry_points={"console_scripts": ["iredis = iredis.entry:main"]},
    packages=['iredis', 'iredis.data', 'iredis.data.commands'],
    package_dir={"": "."},
    package_data={"iredis.data": ["*.csv", "*.json"], "iredis.data.commands": ["*.md"]},
    install_requires=['click==7.*,>=7.0.0', 'configobj==5.*,>=5.0.0', 'importlib-resources==1.0.2', 'mistune==0.*,>=0.8.0', 'pendulum==2.*,>=2.0.0', 'prompt-toolkit==3.*,>=3.0.0', 'pygments==2.*,>=2.0.0', 'redis==3.*,>=3.0.0', 'wcwidth==0.1.9'],
    extras_require={"dev": ["pexpect==4.*,>=4.7.0", "pytest==5.*,>=5.0.0"]},
)
